//
//  GSInstance.h
//  Glyphs
//
//  Created by Georg Seifert on 5.2.08.
//  Copyright 2008 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class GSFont;
@class GSCustomProperty;
/** The class defining the instance object
 */

@interface GSInstance : NSObject <NSCoding, NSCopying> {
	GSFont		*__unsafe_unretained _font;
	NSString	*_name;
	NSString	*_linkStyle;
	float		_interpolationWeight;
	float		_interpolationWidth;
	float		_interpolationCustom;
	NSString	*_weightClass;
	NSString	*_widthClass;
	BOOL		_active;
	BOOL		_isItalic;
	BOOL		_isBold;
	NSMutableDictionary * _instanceInterpolations;
	NSMutableDictionary * _tempData;
	NSMutableArray *_customParameters;
	BOOL		_manualInterpolation;
}
@property(unsafe_unretained, nonatomic) GSFont *font;
/** The Intances name
 
 This is used as the style name.
 */
@property(copy, nonatomic) NSString* name;
/** The style to use as a the regular for this style.
 
 if styleName is `Medium`, you could link to `Light`. So this instance becomes the Bold stil for the Light.
 */
@property(copy, nonatomic) NSString* linkStyle;
/// The interpolation Weight position.
@property(nonatomic) float interpolationWeight;
/// The interpolation Width position
@property(nonatomic) float interpolationWidth;
/// The interpolation Cutom position
@property(nonatomic) float interpolationCustom;
/** Weight Class
 
 e.g. Regular or Bold
 */
@property (strong, nonatomic) NSString* weightClass;
@property (nonatomic) NSUInteger weightClassValue;

/** Width Class
 
 e.g. Medium (normal)
 */
@property (strong, nonatomic) NSString* widthClass;
@property (nonatomic) NSUInteger widthClassValue;

/// If it should be exported.
@property (nonatomic) BOOL active;
/// the Style linking Italic bit
@property (nonatomic) BOOL isItalic;
/// the Style linking Bold bit
@property (nonatomic) BOOL isBold;
@property(strong, nonatomic) NSMutableDictionary * instanceInterpolations;
/// The content of the instance to store it in a pList.
@property(unsafe_unretained) NSDictionary *instanceDict;
@property(strong, nonatomic) NSMutableDictionary *tempData;
@property(strong, nonatomic) NSMutableArray *customParameters;

@property(nonatomic) BOOL manualInterpolation;

- (id) initWithInstance:(GSInstance*) Instance;
#ifndef GLYPHS_VIEWER
- (BOOL) saveToFile:(FILE*) File error:(NSError**) error ;


- (void) updateInterpolationValues ;
//- (void) replaceObjectInCustomParametersAtIndex:(NSUInteger)theIndex withObject:(id)obj;

//- (void)addCustomParameter:(NSMutableDictionary *)aCustomParameter;
//- (void)removeCustomParameter:(NSMutableDictionary *)aCustomParameter;

///////  customParameters  ///////
- (NSArray *) customParameters;
- (NSUInteger) countOfCustomParameters;
- (GSCustomProperty*) objectInCustomParametersAtIndex:(NSUInteger)theIndex;
- (id) customValueForKey:(NSString*) Key;
- (GSCustomProperty*) customPropertyForKey:(NSString*) Key;
- (void) addCustomParameter:(GSCustomProperty *)Property ;
- (void) removeCustomParameter:(GSCustomProperty *)Property ;
- (void) setCustomParameter:(id)value forKey:(NSString*)key;
- (void) removeObjectFromCustomParametersForKey:(NSString*) Key;
- (void) insertObject:(GSCustomProperty *)aCustomProperty inCustomParametersAtIndex:(NSUInteger)idx;
- (void) removeObjectFromCustomParametersAtIndex:(NSUInteger)idx;
- (void) replaceObjectInCustomParametersAtIndex:(NSUInteger)idx withObject:(GSCustomProperty *)aCustomProperty;
- (void) elementDidChange:(id)element;
- (void) scaleBy:(CGFloat) Scale;
#endif
@end
